<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:n1="http://schemas.microsoft.com/SystemDefinitionModel/2005/1/DeploymentReport">
	<xsl:param name="DepDiagram" select="“默认部署关系图”"/>
	<!--depdiag.jpg-->
	<xsl:param name="DistSystem" select="“默认分发系统名称”"/>
	<!--Dist System Name-->
	<xsl:param name="LDDName" select="“默认 LDD 名称”"/>
	<!--DatacenterName-->
	<xsl:param name="LDD" select="“默认 LDD”"/>
	<!-- datacenter.jpg -->
	<xsl:param name="SD" select="“默认 SD”"/>
	<!-- system.jpg-->
	<xsl:param name="IncludeOwners" select="'True'"/>
	<xsl:param name="IncludeDiagrams" select="'True'"/>
	<xsl:param name="BusinessLead" select="''"/>
	<xsl:param name="SoftwareArchitect" select="''"/>
	<xsl:param name="OperationsManager" select="''"/>
	<xsl:param name="DevLead" select="''"/>
	<xsl:param name="TestLead" select="''"/>
	<xsl:param name="ErrorsOnly" select="'False'"/>
	<xsl:param name="TimeStamp" select="'DateTime'"/>
	<xsl:param name="Comments" select="“注释”"/>
	<xsl:param name="Company" select="“公司”"/>
	<xsl:param name="SDMDescription" select="“SDM 说明”"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml" lang="zh-CN">
			<head>
				<style type="text/css">
				a:link, a:active, a:visited
				{
					color:#0066cc;
				}
				div, td, span
				{
					color:#333333;
					font-family:arial;
					font-size:x-small;
					font-weight:normal;
				}
				fieldset
				{
					padding:5;
					margin:5 0 5 0;
				}
				legend
				{
					color:#666666;
					font-weight:bold;
				}
				h1
				{
					border-bottom:1px solid #cccccc;
					color:#0066cc;
					font-family:Arial;
					font-size:large;
					font-weight:normal;
					padding:3 0 3 0;
					margin:5 0 5 0;
				}	
				h4
				{
					border-bottom:1px solid #cccccc;
					color:#666666;
					font-family:Arial;
					font-size:small;
					font-weight:bold;
					padding:3 0 3 0;
					margin:3 0 3 0;
				}
				td.label
				{
					color:#666666;
					width:20%;
				}
				div.zone
				{
					border: 1px dotted #999999;
					padding:5px;
					margin: 5 0 5 0;
				}
				div.system
				{
					background-color:#dddddd;
					border: 1px solid #999999;
					padding:5px;
					margin: 5 0 5 0;
				}
				div.application
				{
					background-color:#CBDAEC;
					border: 1px solid #666666;
					padding:5px;
					margin: 5 0 5 0;
				}
				div.endpoint
				{
					color:#ffffff;
					font-weight:bold;
					background-color:#006600;
					border: 1px solid #ffffff;
					padding: 0 5 0 5;
					width:20px;
				}
				div.resource
				{
					color:#ffffff;
					font-weight:bold;
					background-color:#0066cc;
					border: 1px solid #ffffff;
					padding:0 5 0 5;
					width:20px;
				}
				div.setting
				{
					color:#ffffff;
					font-weight:bold;
					background-color:#990000;
					border: 1px solid #ffffff;
					padding:0 5 0 5;
					width:20px;
				}
				p
				{
					margin:5px;
				}
				td
				{
					vertical-align:top;
				}
				</style>
				<title>部署报告</title>
			</head>
			<body>
				<h1 xmlns="http://www.w3.org/1999/xhtml" id="Title">
					
					<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="$DistSystem"/> 到
					<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="$LDDName"/> 数据中心的部署的 SDM 报告
				</h1>
				<table style="width:100%">
					<tr>
						<td class="label">创建日期</td>
						<td class="value">
							<xsl:value-of select="$TimeStamp"/>
						</td>
					</tr>
					<xsl:if test="$Company!=''">
						<tr>
							<td class="label">公司</td>
							<td class="value">
								<xsl:value-of select="$Company"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$Comments!=''">
						<tr>
							<td class="label">注释</td>
							<td class="value">
								<xsl:value-of select="$Comments"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$SDMDescription!=''">
						<tr>
							<td class="label">SDM 说明</td>
							<td class="value">
								<xsl:value-of select="$SDMDescription"/>
							</td>
						</tr>
					</xsl:if>
				</table>
				<!-- OWNERS -->
				<xsl:if test="$IncludeOwners='True'">
					<h4>所有者</h4>
					<table style="width:100%">
						<tr>
							<td class="label">业务组长</td>
							<td class="value">
								<xsl:value-of select="$BusinessLead"/>
							</td>
						</tr>
						<tr>
							<td class="label">软件设计师</td>
							<td class="value">
								<xsl:value-of select="$SoftwareArchitect"/>
							</td>
						</tr>
						<tr>
							<td class="label">运营经理</td>
							<td class="value">
								<xsl:value-of select="$OperationsManager"/>
							</td>
						</tr>
						<tr>
							<td class="label">开发组长</td>
							<td class="value">
								<xsl:value-of select="$DevLead"/>
							</td>
						</tr>
						<tr>
							<td class="label">测试组长</td>
							<td class="value">
								<xsl:value-of select="$TestLead"/>
							</td>
						</tr>
					</table>
				</xsl:if>
				<!-- ERRORS -->
				<xsl:if test="n1:DeploymentReport/n1:Errors/n1:*">
					<h4>错误和警告</h4>
					<table style="width:100%">
						<xsl:for-each select="n1:DeploymentReport/n1:Errors/n1:*">
							<xsl:if test="not(@ConstraintDefinition='System:CheckHostingRelationshipForObject' and contains(n1:FailedInput, 'Roles/InstanceName'))">
								<tr>
									<td class="label" style="color:#ff0000;">
										<xsl:value-of select="name()"/>
									</td>
									<td class="value" style="color:#ff0000;">
										<xsl:value-of select="n1:Description"/>
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>
					</table>
				</xsl:if>
				<!-- LEGEND -->
				<xsl:if test="$ErrorsOnly!='True'">
					<h4>图例</h4>
					<table style="width:600;">
						<tr>
							<td style="width:20px;text-align:center;">
								<div class="zone" style="padding:0;margin:0;"/>
							</td>
							<td class="value">区域</td>
						</tr>
						<tr>
							<td style="text-align:center;">
								<div class="system" style="padding:0;margin:0;"/>
							</td>
							<td class="value">系统或应用程序宿主</td>
						</tr>
						<tr>
							<td style="text-align:center;">
								<div class="application" style="padding:0;margin:0;"/>
							</td>
							<td class="value">应用程序</td>
						</tr>
						<tr>
							<td style="text-align:center;">
								<div class="endpoint" style="padding:0;margin:0;">E</div>
							</td>
							<td class="value">终结点</td>
						</tr>
						<tr>
							<td style="text-align:center;">
								<div class="resource" style="padding:0;margin:0;">R</div>
							</td>
							<td class="value">资源</td>
						</tr>
						<tr>
							<td style="text-align:center;">
								<div class="setting" style="padding:0;margin:0;">S</div>
							</td>
							<td class="value">设置</td>
						</tr>
					</table>
					<xsl:for-each select="n1:DeploymentReport/n1:Binding">
						<h4>绑定</h4>
						<xsl:apply-templates select="n1:Zone"/>
						<xsl:apply-templates select="n1:BoundLogicalServer"/>
					</xsl:for-each>
					<xsl:if test="$IncludeDiagrams='True'">
						<h4>部署关系图</h4>
						<img src="{$DepDiagram}" alt="将 {$DistSystem} 系统部署到 {$LDDName} 数据中心的关系图"/>
					</xsl:if>
					<xsl:for-each select="n1:DeploymentReport/n1:LogicalServers">
						<h4>逻辑服务器</h4>
						<xsl:apply-templates select="n1:Zone" mode="ID"/>
						<xsl:apply-templates select="n1:LogicalServer"/>
					</xsl:for-each>
					<xsl:if test="$IncludeDiagrams='True'">
						<h4>逻辑数据中心关系图</h4>
						<img src="{$LDD}" alt="{$LDDName} 数据中心关系图"/>
					</xsl:if>
					<xsl:for-each select="n1:DeploymentReport/n1:Applications">
						<h4>系统</h4>
						<xsl:apply-templates select="n1:System"/>
						<xsl:apply-templates select="n1:Application"/>
					</xsl:for-each>
					<xsl:if test="$IncludeDiagrams='True'">
						<h4>系统关系图</h4>
						<img src="{$SD}" alt="系统关系图"/>
					</xsl:if>
					<xsl:for-each select="descendant::n1:Resource">
						<xsl:if test="n1:Setting[descendant::n1:Value] or n1:Resource[descendant::n1:Value]">
							<fieldset>
								<legend>
									<a id="{@InstanceId}">资源 '<xsl:value-of select="@Name"/>'</a>
								</legend>
								<div style="font-size:80%;padding-left:8px;">
									<xsl:for-each select="ancestor::n1:*[@Name]">
										<xsl:choose>
											<xsl:when xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="@InstanceId">
												<a xmlns="http://www.w3.org/1999/xhtml" href="#{@InstanceId}">
													<xsl:value-of select="@Name"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="@Name"/>
											</xsl:otherwise>
										</xsl:choose>

									:

									</xsl:for-each>
									<xsl:value-of select="@Name"/>
								</div>
								<xsl:if test="n1:Resource | n1:Setting">
									<div style="margin:5px">
										<table cellspacing="1" cellpadding="0" width="90%">
											<xsl:apply-templates select="n1:Resource">
												<xsl:sort select="@Name" data-type="text" order="ascending"/>
											</xsl:apply-templates>
											<xsl:apply-templates select="n1:Setting">
												<xsl:sort select="@Name" data-type="text" order="ascending"/>
											</xsl:apply-templates>
										</table>
									</div>
								</xsl:if>
								<div style="text-align:right;font-size:80%">
									<a href="#{../@InstanceId}">返回到父级</a>
								</div>
							</fieldset>
						</xsl:if>
					</xsl:for-each>
					<xsl:for-each select="descendant::n1:Endpoint">
						<xsl:if test="n1:Setting[descendant::n1:Value]">
							<fieldset>
								<legend>
									<a id="{@InstanceId}">终结点 '<xsl:value-of select="@Name"/>'</a>
								</legend>
								<div style="font-size:80%;padding-left:8px;">
									<xsl:for-each select="ancestor::n1:*[@Name]">
										<xsl:choose>
											<xsl:when xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="@InstanceId">
												<a xmlns="http://www.w3.org/1999/xhtml" href="#{@InstanceId}">
													<xsl:value-of select="@Name"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="@Name"/>
											</xsl:otherwise>
										</xsl:choose>
								:
							</xsl:for-each>
									<xsl:value-of select="@Name"/>
								</div>
								<xsl:if test="n1:Resource | n1:Setting/n1:Value | n1:Setting/n1:Facet ">
									<div style="margin:5px">
										<table cellspacing="1" cellpadding="0" width="90%">
											<xsl:apply-templates select="n1:Resource">
												<xsl:sort select="@Name" data-type="text" order="ascending"/>
											</xsl:apply-templates>
											<xsl:apply-templates select="n1:Setting">
												<xsl:sort select="@Name" data-type="text" order="ascending"/>
											</xsl:apply-templates>
										</table>
									</div>
								</xsl:if>
								<div style="text-align:right;font-size:80%">
									<a href="#{../@InstanceId}">返回到父级</a>
								</div>
							</fieldset>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
				<!-- $ErrorsOnly -->
			</body>
		</html>
	</xsl:template>
	<xsl:template match="n1:Zone">
		<div class="zone">
			<b>区域</b>: 
				<xsl:value-of select="@Name"/>
			<table cellspacing="1" cellpadding="0" width="90%">
				<!--the <tr> below is to prevent some XSL transformers from  closing the table tag in place -->
				<tr>	</tr>
				<xsl:apply-templates select="n1:Endpoint">
					<xsl:sort select="@Name" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</table>
			<table cellspacing="1" cellpadding="0" width="90%">
				<!-- the <tr> below is to prevent some XSL transformers from  closing the table tag in place -->
				<tr>	</tr>
				<xsl:apply-templates select="n1:Setting">
					<xsl:sort select="@Name" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</table>
			<xsl:apply-templates select="n1:Zone"/>
			<xsl:apply-templates select="n1:LogicalServer"/>
			<xsl:apply-templates select="n1:BoundLogicalServer"/>
		</div>
	</xsl:template>
	<xsl:template match="n1:Zone" mode="ID">
		<div class="zone">
			<b>区域</b>: 
				<a id="{@InstanceId}">
					<xsl:value-of select="@Name"/>
				</a>
			<table cellspacing="1" cellpadding="0" width="90%">
				<!--the <tr> below is to prevent some XSL transformers from  closing the table tag in place -->
				<tr>	</tr>
				<xsl:apply-templates select="n1:Endpoint">
					<xsl:sort select="@Name" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</table>
			<table cellspacing="1" cellpadding="0" width="90%">
				<!-- the <tr> below is to prevent some XSL transformers from  closing the table tag in place -->
				<tr>	</tr>
				<xsl:apply-templates select="n1:Setting">
					<xsl:sort select="@Name" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</table>
			<xsl:apply-templates select="n1:Zone" mode="ID"/>
			<xsl:apply-templates select="n1:LogicalServer"/>
			<xsl:apply-templates select="n1:BoundLogicalServer"/>
		</div>
	</xsl:template>
	<xsl:template match="n1:System">
		<div class="system">
			<b>系统名称: </b>
			<xsl:value-of select="@Name"/>
			<br/>
			<xsl:apply-templates select="n1:System"/>
			<xsl:apply-templates select="n1:Application"/>
		</div>
	</xsl:template>
	<xsl:template match="n1:BoundLogicalServer">
		<div class="system">
			<b>宿主</b>: <xsl:value-of select="@Name"/>
			<br/>
			<b>扩展</b>: <xsl:value-of select="@Extends"/>
			<xsl:apply-templates select="n1:Application"/>
		</div>
	</xsl:template>
	<xsl:template match="n1:Application">
		<div class="application">
			<b>应用程序名</b>: 
			<xsl:if test="name(parent::node())='System' or name(parent::node())='Application' ">
				<a id="{@InstanceId}">
					<xsl:value-of select="@Name"/>
				</a>
			</xsl:if>
			<xsl:if test="not (name(parent::node())='System' or name(parent::node())='Application' ) ">
				<xsl:value-of select="@Name"/>
			</xsl:if>
			<br/>
			<b>扩展</b>: <xsl:value-of select="@Extends"/>
			<div>
				<table cellspacing="1" cellpadding="0" width="90%">
					<!-- the <tr> there is to prevent some XSL transformers from  closing the table tag in place -->
					<tr>	</tr>
					<xsl:apply-templates select="n1:Endpoint"/>
					<xsl:apply-templates select="n1:Resource">
						<xsl:sort select="@Name" data-type="text" order="ascending"/>
					</xsl:apply-templates>
					<xsl:apply-templates select="n1:Setting">
						<xsl:sort select="@Name" data-type="text" order="ascending"/>
					</xsl:apply-templates>
				</table>
			</div>
		</div>
	</xsl:template>
	<xsl:template match="n1:LogicalServer">
		<div class="system">
			<b>宿主</b>:<a id="{@InstanceId}">
				<xsl:value-of select="@Name"/>
			</a>
			<br/>
			<b>扩展</b>: <xsl:value-of select="@Extends"/>
			<table cellspacing="1" cellpadding="0" width="90%">
				<!-- the <tr> below is to prevent some XSL transformers from  closing the table tag in place -->
				<tr>	</tr>
				<xsl:apply-templates select="n1:Endpoint"/>
				<xsl:apply-templates select="n1:Resource">
					<xsl:sort select="@Name" data-type="text" order="ascending"/>
				</xsl:apply-templates>
				<xsl:apply-templates select="n1:Setting">
					<xsl:sort select="@Name" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</table>
		</div>
	</xsl:template>
	<xsl:template match="n1:Endpoint">
		<tr>
			<td style="width:20;">
				<div class="endpoint">E</div>
			</td>
			<td style="width:220;">
				<a href="#{@InstanceId}">
					<xsl:value-of select="@Name"/>
				</a>
			</td>
			<td>
				<xsl:value-of select="@Extends"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="n1:Resource">
		<tr>
			<td style="width:20;">
				<div class="resource">R</div>
			</td>
			<td style="width:220;">
				<a href="#{@InstanceId}">
					<xsl:value-of select="@Name"/>
				</a>
			</td>
			<td>
				<xsl:value-of select="@Extends"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="n1:Setting">
		<xsl:if test="not(n1:Facet) and *">
			<tr>
				<xsl:if test="@Name='ConnectedToEndpoints'">
					<td style="width:20;">
						<div class="setting">S</div>
					</td>
					<td style="width:30%;padding-top:1;">
						<xsl:value-of select="@Name"/>
					</td>
					<td>
						<xsl:for-each select="child::*">
							<xsl:variable name="IID" select="text()"/>
							<xsl:if test="//n1:Endpoint/@Definition[../@InstanceId=$IID]!=''">
								<a href="#{$IID}">
									<xsl:value-of select="//n1:Endpoint/@Name[../@InstanceId=$IID]"/>(<xsl:value-of select="substring-after 	(//n1:Endpoint/@Definition[../@InstanceId=$IID],':')"/>)</a>
								<xsl:text>
</xsl:text>
								<xsl:if test="count(parent::*/*)&gt;1">
									<br/>
								</xsl:if>
							</xsl:if>
							<xsl:if test="not (//n1:Endpoint/@Definition[../@InstanceId=$IID]) and count(parent::*/*)=1">
										Not Connected
								</xsl:if>
						</xsl:for-each>
					</td>
				</xsl:if>
				<xsl:if test="@Name!='ConnectedToEndpoints'">
					<td style="width:20;">
						<div class="setting">S</div>
					</td>
					<td style="width:30%;padding-top:1;">
						<xsl:value-of select="@Name"/>
					</td>
					<td>
						<xsl:apply-templates select="n1:Value">
							<xsl:sort select="name" data-type="text" order="ascending"/>
						</xsl:apply-templates>
					</td>
				</xsl:if>
			</tr>
			<xsl:text>
</xsl:text>
		</xsl:if>
		<xsl:for-each select="n1:Facet">
			<xsl:sort select="name" data-type="text" order="ascending"/>
			<xsl:if test="*">
				<tr>
					<td style="width:20;">
						<div class="setting">S</div>
					</td>
					<td style="width:30%;">
						<xsl:value-of select="../@Name"/>(<xsl:value-of select="@Name"/>)</td>
					<td>
						<xsl:apply-templates select="n1:Value">
							<xsl:sort select="name()" data-type="text" order="ascending"/>
						</xsl:apply-templates>
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="n1:Value">
		<xsl:if test="not(*)">
			<xsl:value-of select="."/>
			<xsl:if test="count(parent::*/*)&gt;1">
				<br/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="*">
			<table>
				<xsl:for-each select="*">
					<xsl:sort select="name()" data-type="text" order="ascending"/>
					<tr>
						<td style="width:220;">
							<xsl:value-of select="name()"/>
						</td>
						<td>
							<xsl:value-of select="."/>
						</td>
					</tr>
				</xsl:for-each>
			</table>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
